%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function [mean_ratio] = compute_mean_ratio2(coords);

x1=coords.x1;
x2=coords.x2;
x3=coords.x3;
y1=coords.y1;
y2=coords.y2;
y3=coords.y3;

A = [x2-x1 x3-x1; y2-y1 y3-y1];

W = [1 0.5; 0 sqrt(3)/2];
invW = inv(W);

T=A*invW;

mean_ratio = (norm(T,'fro')^2)/(2*det(T));
